/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: PNIOCMCTL_Functionlist.h $
   Last Modification:
    $Author: Matthias $
    $Modtime: 23.01.07 10:52 $
    $Revision: 1 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    PNIO CMCTL
    Task function list for configuration file
       
   Changes:
 
    Date        Author   Description
    ----------- -------- ---------------------------------------------------------
    2010-09-24  bm       added name and instance to identify DrvEdd to startup parameters
                         changed parameter version to 2 (this is an incompatible change!)
                            old parameter version 1 is no longer supported by this task
        
**************************************************************************************/
/**
 * @file PNIOCMCTL_Functionlist.h
 * @brief PNIO CMCTL - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNM_PNIOCMCTL</code>
 * of task.
 */
#ifndef __PNIO_CMCTL_FUNCTIONLIST_H
#define __PNIO_CMCTL_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNM_PNIOCMCTL
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskEnter_PNM_PNIOCMCTL
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
/* note: the change between V2 and old V1 are incompatible so that V1 is no longer accepted */
#define PNIO_CMCTL_STARTUP_PARAM_VERSION_2   (2)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNIO_CMCTL_STARTUPPARAMETER_Ttag  PNIO_CMCTL_STARTUPPARAMETER_V2_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNIO_CMCTL_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;
  
  /** maximum context management protocol machine
   *
   * The member defines the maximum number of context management protocol machines
   * of PROFINET IO-Controller.
   */
  TLR_UINT    uiMaxCmctl;

  /* new for V2 */
  /* EDD name to identify */
  TLR_STR*    pszEddName;
  /* EDD instance */
  TLR_UINT    uiEddInstance;

};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNIO_CMCTL_FUNCTIONLIST_H */
